-- Notes MacroScript File
--
-- Created:  		Dec 1 2000
-- Last Updated: 	Dec 20 2000
--
-- Author :   Frederick Ruff
/*
Version:  3ds max 6

 
This script adds Popup Notes to scene files.
***********************************************************************************************
 MODIFY THIS AT YOUR OWN RISK
 

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	22 jan 2014, Larry Minton, 
		handle quotes in comment

*/

MacroScript AddPopupNote
ButtonText:~ADDPOPUPNOTE_BUTTONTEXT~
Category:~ADDPOPUPNOTE_CATEGORY~ 
internalCategory:"Pop up Note" 
Tooltip:~ADDPOPUPNOTE_TOOLTIP~ 
(
	/* "Localize On" */
	--Persistent Global Note_NoteString
	--Persistent Global Note_AuthorString
	--Persistent Global Note_TextString
	rollout NoteRollout ~NOTEROLLOUT_POP_UP_NOTE~ width:500 height:400
	(
		Edittext auth ~AUTHOR_CAPTION~ pos:~AUTHOR_POSITION~ width:~AUTHOR_WIDTH~ height:~AUTHOR_HEIGHT~ fieldwidth:150 text:""
		Edittext dtstmp ~DATE_CAPTION~ pos:~DATE_POSITION~ width:~DATE_WIDTH~ height:~DATE_HEIGHT~ fieldwidth:150 offset:[8,0] text:localtime
		Checkbox Persist ~SHOW_NOTE_ON_FILE_OPEN~ checked:true pos:~SHOW_NOTE_ON_FILE_OPEN_POSITION~ width:~SHOW_NOTE_ON_FILE_OPEN_WIDTH~ height:~SHOW_NOTE_ON_FILE_OPEN_HEIGHT~
		Edittext line1 pos:~LINE1_POSITION~ width:~LINE1_WIDTH~ height:200 text:""
		Button CanclAll ~CANCEL_CAPTION~ pos:~CANCEL_POSITION~ width:75 height:~CANCEL_HEIGHT~ offset:~CANCEL_OFFSET~
		Button Go ~ADD_NOTE_CAPTION~ pos:~ADD_NOTE_POSITION~ width:~ADD_NOTE_WIDTH~ height:~ADD_NOTE_HEIGHT~ offset:[190,-26]
	
	On Go pressed do
		(
		callbacks.removescripts id:#SceneNote
		
		local sAuthor = substituteString auth.text "\"" "\\\""
		local sComment = substituteString line1.text "\"" "\\\""
		Persistent Global Note_NoteString = "Messagebox \"" + ~AUTHOR~ + sAuthor +"\n"+dtstmp.text+~NOTE_COMMENTS~+ sComment + "\"" + ~POP_UP_NOTE_TITLE~
		Persistent Global Note_AuthorString = auth.text
		Persistent Global Note_TextString = line1.text
		If Persist.checked == true do callbacks.addscript #filepostopen "Execute Note_NoteString" id:#SceneNote persistent:true
		destroydialog NoteRollout
		fileproperties.addproperty #summary "Comments" (replace_LF_with_CRLF Note_TextString) -- summary window requires \r\n for new lines.
		fileproperties.addproperty #summary "Author" Note_AuthorString

		)
	On NoteRollout Open do 
		(
			local idx = fileProperties.findProperty #summary "Author"
			local sAuthor = ""
			if idx != 0 do
				sAuthor = fileProperties.getPropertyvalue #summary idx
			if (sAuthor.count == 0) do 
				sAuthor = sysinfo.username
			auth.text = sAuthor
			idx  = fileProperties.findProperty #summary "Comments"
			local sComment = ""
			if idx != 0 do
				sComment = fileProperties.getPropertyvalue #summary idx
			line1.text = replace_CRLF_with_LF sComment
		)
	On CanclAll pressed do destroydialog NoteRollout
	)
	CreateDialog  NoteRollout  width:500 height:300		
	
)

MacroScript ReadPopupNote
ButtonText:~READPOPUPNOTE_BUTTONTEXT~
Category:~READPOPUPNOTE_CATEGORY~ 
internalCategory:"Pop up Note" 
Tooltip:~READPOPUPNOTE_TOOLTIP~ 
(
	If Note_NoteString != undefined then Execute Note_NoteString
	Else  MessageBox ~MSGBOX_NO_NOTES_PRESENT~ Title:~MSGBOX_NO_NOTES_PRESENT_TITLE~ beep:no
)

MacroScript DeletePopupNote
ButtonText:~DELETEPOPUPNOTE_BUTTONTEXT~
Category:~DELETEPOPUPNOTE_CATEGORY~
internalCategory:"Pop up Note" 
Tooltip:~DELETEPOPUPNOTE_TOOLTIP~ 
(
	If Note_NoteString != undefined then
	(
		 if querybox ~QUERYBOX_ARE_YOU_SURE~ then 
		(
		callbacks.removescripts id:#SceneNote
		messagebox ~MSGBOX_THE_NOTE_HAS_BEEN_DELETED~ title:~MSGBOX_THE_NOTE_HAS_BEEN_DELETED_TITLE~ beep:no
		Note_NoteString = undefined
		)
	)
	Else  MessageBox ~MB_NO_NOTES_PRESENT~ Title:~MB_NO_NOTES_PRESENT_TITLE~ beep:no
)

MacroScript SupressPopupNote
ButtonText:~SUPRESSPOPUPNOTE_BUTTONTEXT~
Category:~SUPRESSPOPUPNOTE_CATEGORY~ 
internalCategory:"Pop up Note" 
Tooltip:~SUPRESSPOPUPNOTE_TOOLTIP~ 
(
	if Note_NoteString != undefined then
		(
		callbacks.removescripts id:#SceneNote
	
		messagebox ~MSGBOX_THE_NOTE_HAS_BEEN_SUPPRESSED~ title:~MSGBOX_THE_NOTE_HAS_BEEN_SUPPRESSED_TITLE~ beep:no
		)
	Else MessageBox ~MSGBOX_NO_NOTE_PRESENT~ Title:~MSGBOX_NO_NOTE_PRESENT_TITLE~ beep:no
)
/* "Localize Off" */


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAZw4RFrs3B7NIuIA2R4pvvsOlh/oTzpTdp
-- m/mgxT3bSb40nBqB4XPKc9VzM+FCL0tyHqATIdkC8ZqeiiDLL4k5RRwgX4Ws+q7g
-- /IGcJbwYxk0051ysHjtty5wYxNwujxEV64Rk3aHF5QTFe/g9Fp5/yrGfo+rh7IpD
-- sN3CiXIBrVp59zeKKc0gGeTvhp9QEweRpf0opF4ZDYuFNElTKuqB8ScjvdGydsRO
-- qhinIQqPfknxfKMiOhOfGv7sVcigI0F1g+9oKq8QwJFRsuN1a/IaLxH04LQu7O3V
-- K/A/GEtp8knEOjOIFKdr4XklojijuzYvzTxLs/k+haEAHOOMcNvi
-- -----END-SIGNATURE-----